unit Krok4;

interface

uses
  ZamwieniaInterfejsy;

type
  TZamwienie = class(TInterfacedObject, IZamwienie)
    function Warto: integer;
  end;

  TWeryfikacjaZamwienia = class(TInterfacedObject, IWeryfikacjaZamwienia)
    procedure WeryfikujZamwienie(aZamwienie: IZamwienie);
  end;

  TRealizacjaZamwienia = class
  private
    FWeryfikacjaZamwienia: IWeryfikacjaZamwienia;
  public
    constructor Create(aWeryfikacjaZamwienia: IWeryfikacjaZamwienia);
    procedure RealizujZamwienie(aZamwienie: IZamwienie);
  end;

procedure RealizujZamwienia4;

implementation

uses
  System.SysUtils;

procedure RealizujZamwienia4;
var
  Zamwienie: IZamwienie;
  RealizacjaZamwienia: TRealizacjaZamwienia;
begin
  RealizacjaZamwienia := TRealizacjaZamwienia.Create(TWeryfikacjaZamwienia.Create);
  try
    Zamwienie := TZamwienie.Create;
    RealizacjaZamwienia.RealizujZamwienie(Zamwienie);
  finally
    RealizacjaZamwienia.Free;
  end;
end;

function TZamwienie.Warto: integer;
begin
  Result := Random(1000) + 1
end;

constructor TRealizacjaZamwienia.Create(aWeryfikacjaZamwienia: IWeryfikacjaZamwienia);
begin
  inherited Create;
  FWeryfikacjaZamwienia := aWeryfikacjaZamwienia;
end;

procedure TRealizacjaZamwienia.RealizujZamwienie(aZamwienie:IZamwienie);
begin
  FWeryfikacjaZamwienia.WeryfikujZamwienie(aZamwienie);
end;

procedure TWeryfikacjaZamwienia.WeryfikujZamwienie(aZamwienie: IZamwienie);
begin
  WriteLn('Warto zamwienia: ' + IntToStr(aZamwienie.Warto));
end;

end.
